<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Modules\OrderModule;

class DashboardController extends Controller
{
    public function orders(OrderModule $ordermodule)
    {
    	
    	$params = request()->all();
        $per_page = 50;
        if (isset($params['per_page'])) $per_page = (int) $params['per_page'];

        if ( count($params) <= 1 && !isset($params['q']) ) {
            $orders = $ordermodule->paginate(50);
        } else {
            $orders = $ordermodule->filter($params);
        }

    	return view('orders')->with(compact('orders', 'params'));
    	return compact('orders');
    }
}
