<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Modules\LandingPageModule;
use App\Modules\DataModule;
use App\Modules\OperatorModule;

class LandingPageController extends Controller
{
    public function desimlocker() 
    {
    	$data = $this->preparePageData('desimlocker');
        $data['cta'] = 'Désimlocker mon Téléphone';
    	$data['keyword'] = 'desimlocker';
    	return view('landingpages.desimlocker')->with($data);
    }

    public function debloquer() 
    {
    	$data = $this->preparePageData('debloquer');
    	$data['cta'] = 'Debloquer mon Téléphone';
        $data['keyword'] = 'debloquer';
    	return view('landingpages.debloquer')->with($data);
    }

    public function desimlockage() 
    {
    	$data = $this->preparePageData('desimlockage');
    	$data['cta'] = 'Desimlockage du Téléphone';
        $data['keyword'] = 'desimlockage';
    	return view('landingpages.desimlockage')->with($data);
    }

    public function deblocage() 
    {
    	$data = $this->preparePageData('deblocage');
    	$data['cta'] = 'Déblocage portable';
        $data['keyword'] = 'deblocage';
    	return view('landingpages.deblocage')->with($data);
    }

    public function desimlockerName($name = '') 
    {
    	$data = $this->preparePageData('desimlocker');
    	$data['name'] = $name;
        $data['keyword'] = 'desimlocker';
    	return view('landingpages.desimlocker.'.$name)->with($data);
    }

    public function debloquerName($name = '') 
    {
        $data = $this->preparePageData('debloquer');
        $data['name'] = $name;
        $data['keyword'] = 'debloquer';
        return view('landingpages.debloquer.'.$name)->with($data);
    }

    public function desimlockageName($name = '') 
    {
        $data = $this->preparePageData('desimlockage');
        $data['name'] = $name;
        $data['keyword'] = 'desimlockage';
        return view('landingpages.desimlockage.'.$name)->with($data);
    }

    public function deblocageName($name = '') 
    {
        $data = $this->preparePageData('deblocage');
        $data['name'] = $name;
        $data['keyword'] = 'deblocage';
        return view('landingpages.deblocage.'.$name)->with($data);
    }

    function preparePageData($keyword = '') 
    {
    	$landingpagemodule = new LandingPageModule();
    	$datamodule = new DataModule();
    	$operatormodule = new OperatorModule();

    	$testimonials = $landingpagemodule->getRootTestimonialsByKeyword($keyword);
    	$manufacturers = $datamodule->getActiveManufacturers();
        $operators = $operatormodule->getActiveOperators();
        $selected_manufacturer = '';
        return compact('testimonials', 'manufacturers', 'operators', 'selected_manufacturer');
    }
}
