<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Modules\OrderModule;
use App\Modules\DataModule;
use App\Modules\OperatorModule;
use App\Modules\PriceModule;

use Validator;

class OrderController extends Controller
{
	protected $operator_country = 'France';

    public function addToCart(OrderModule $ordermodule, OperatorModule $operatormodule, PriceModule $pricingmodule)
    {

    	$inputs = request()->all();

    	$rules = [
            'email' => 'required|email',
            'model' => 'required|string|min:1',
            'operator_id' => 'required|string',
            'imei' => 'required|string|size:15',
            'phone' => 'required|string|min:2'
        ];

        $validator = Validator::make($inputs, $rules);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

    	$phone = strip_tags($inputs['phone']);
		$model = strip_tags($inputs['model']);
		$operator_id = strip_tags($inputs['operator_id']);
		$imei = strip_tags($inputs['imei']);
		$email = strip_tags($inputs['email']);

	    $operator_prices = $operatormodule->getPricing($this->operator_country, env('WEBSITE_ID'));
	    $operator = $operatormodule->getOperator($operator_id);
		$operator_parent_uid = is_object($operator) ? $operator->parent_id : 0;

		$price = $operator_prices['OTHER_OPERATOR'];
		if($operator_parent_uid > 0){
			$price = $operator_prices[$operator_parent_uid];
		}

		$parent_operator_name = '';
		if(is_object($operator->parent)) $parent_operator_name = $operator->parent->name;

		if(strcmp($phone, 'Nokia') == 0){
			$price = $operator_prices['NOKIA_BB5'];
			if($operatormodule->isNokiaDct4($model)){
				$price = $operator_prices['NOKIA_DCT4'];
			}
		}

		$pricing_criterias = ['phone' => $phone, 'model' => $model, 'operator' => $operator->name, 'parent_operator_name' => $parent_operator_name];
		$price = $pricingmodule->getPrice($pricing_criterias, $operator_prices, $price);

		//return compact('phone', 'model', 'operator', 'imei', 'email');

		if( !empty($phone) && !empty($model) &&  is_object($operator) &&  !empty($imei) && !empty($email) ) {

			$empty_fields = array(
				'lastname' => '',
				'firstname' => '',
				'imei_modified' => '',
				'model_modified' => '',
				'provider_uid' => '',
				'serial_number' => '',
				'browser_version' => request()->header('User-Agent'),
				'unlock_code' => '',
				'return_stamp' => 0,
				'promo_sixmonth' => 0,
				'auto_send_on' => 0,
				'website_version' => '',
				'tagline' => '',
				'paypal_txn_id' => '',
				'paypal_fname' => '',
				'paypal_lname' => '',
				'case_type' => '',
				'dispute_created' => 0,
				'dateextracted' => 0,
				'accessory_notified' => 0,
				'datecodesent' => 0
			);
		
			$string_fields = array(
				'website_id' => env('WEBSITE_ID'),
				'website' => "debloquertelephone.com",
				'imei' => $imei,
				'amount' => $price,
				'phone' => $phone,
				'model' => $model,
				'operator' => $operator->name . $parent_operator_name,
				'operator_country' => $this->operator_country,
				'user_ip' => request()->ip(),			
				'pageview_id' => 1,
				'email' => $email,
				'dateadded' => time(),
				'datemodified' => time(),
				'search_source' => 0,
				'status' => 'pending',
			);


			$string_fields = array_merge($empty_fields, $string_fields);

			$purchase_id = $ordermodule->getPurchaseIdByEmailImeiAndOperator($email, $imei, $operator->name . $parent_operator_name);
			if($purchase_id <= 0){
				$order = $ordermodule->saveOrder($string_fields);
				$purchase_id = is_object($order) ? $order->id : 0;
			}
			else{
				$string_fields = array(
					'amount' => $price,
					'phone' => $phone,
					'model' => $model,
					'operator_country' => $this->operator_country,
					'user_ip' => request()->ip(),				
					'dateadded' => time(),
					'datemodified' => time(),
				);
				$ordermodule->update($purchase_id, $string_fields);
			}

			session(array('order_id' => $purchase_id));
			session(array('price' => $price));

			return redirect('confirm');
		}

		return redirect()->back()->withInput();


    }
}
