<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Modules\DataModule;
use App\Modules\OperatorModule;
use App\Modules\OrderModule;

class SiteController extends Controller
{
    public function home(DataModule $datamodule, OperatorModule $operatormodule, OrderModule $ordermodule)
    {
        $inputs = request()->all();
        $manufacturers = $datamodule->getActiveManufacturers();
        $operators = $operatormodule->getActiveOperators();

        $selected_manufacturer = '';
        if(isset($inputs['phone'])) {
            $selected_manufacturer = $datamodule->getManufacturerByName(strip_tags($inputs['phone']));
        }
        $order = '';
        if (session()->has('order_id')) {
            $order_id = session('order_id');
            $order = $ordermodule->getOneById($order_id);
        }
    	return view('home')->with(compact('manufacturers', 'operators', 'order', 'selected_manufacturer'));
    }

    public function getModelsByManufacturer(DataModule $datamodule)
    {
    	$manufacturer_name = strip_tags(request()->input('manufacturer'));
    	$manufacturer = $datamodule->getManufacturerByExactName($manufacturer_name);
    	if(is_object($manufacturer)) $models = $datamodule->getModelsByManufacturer($manufacturer->id); 
    	return response()->json(compact('models'));
    }

    public function terms()
    {
    	return view('tos');
    }

    public function privacyPolicy()
    {
    	return view('privacy-policy');
    }

    public function thankYou()
    {
    	return view('thank-you');
    }

    public function checkout()
    {
    	return view('checkout');
    }

    public function contact()
    {
    	return view('contact');
    }

    public function track()
    {
        if(!session()->has('order')) {
            $order = '';
        } else {
            $order = session('order');
        }
        return view('track-order')->with(compact('order'));
    }

    public function trackOrder(OrderModule $ordermodule)
    {
        $inputs = request()->all();
        $order = $ordermodule->getOneByImei(strip_tags($inputs['imei']));
        if(!is_object($order)) {
            $status_message = "Le numero Imei saisie est incorrect. Merci de re-saisir votre imei en tapant *#06# sur le clavier";
            return redirect('suivi')->with('error', $status_message);
        }
        return redirect('suivi')->with('order', $order);
    }

    public function confirm(OrderModule $ordermodule)
    {
        $inputs = request()->all();
        if(!session()->has('order_id')) return redirect('/');
        $order_id = session('order_id');
        $order = $ordermodule->getOneById($order_id);
        if(!is_object($order)) return redirect('/');
        return view('checkout')->with(compact('order'));
    }

    public function manipulation($brand = '')
    {
        $brands = ['acer', 'alcatel', 'apple', 'archos', 'asus', 'benq', 'benq-siemens', 'blackberry', 'bouygues', 'caterpillar', 'coolpad', 'doro', 'elephone', 'ericsson', 'global-high-tech', 'google-nexus', 'honor', 'hp', 'htc', 'huawei', 'ice-phone', 'intel', 'intel', 'lenovo', 'lg', 'meizu', 'microsoft', 'mitsubishi', 'modelabs', 'motorola', 'nec', 'nokia', 'oneplus', 'orange', 'palm', 'panasonic', 'qtek'];
        $brand = strtolower(strip_tags($brand));
        if(!in_array($brand, $brands)) $brand = '';
    	return view('manipulation')->with(compact('brand'));
    }

    public function faq()
    {
        return view('faq');
    }

    public function trackPaidOrder()
    {
        return view('track-order-paid');
    }

    public function trackPendingOrder()
    {
        return view('track-pending-order');
    }

    public function trackCodeSentOrder()
    {
        return view('track-code-sent-order');
    }
}
