<?php namespace App\Modules;

use App\Manufacturer;
use App\Operator;
use App\Price;
use App\PhoneModel;

class DataModule {

	public function getActiveManufacturers()
	{
		$brands = ['Apple', 'Samsung', 'Alcatel', 'HTC', 'LG'];
		$top_5_manufacturers = Manufacturer::select('id', 'name')->whereStatus(1)->whereIn('name', $brands)->orderBy('name')->get();
		$manufacturers = Manufacturer::select('id', 'name')->whereStatus(1)->whereNotIn('name', $brands)->orderBy('priority_order')->get();
		return $top_5_manufacturers->merge($manufacturers);
	}

	public function getManufacturerByName($name = '') {
		return Manufacturer::where('name', 'like', $name.' %')->first();
	}

	public function getManufacturerByExactName($name = '') {
		return Manufacturer::where('name', $name)->first();
	}

	public function getModelsByManufacturer($manufacturer_id) {
		return PhoneModel::where('manufacturer_id',  $manufacturer_id)->get();
	}

}