<?php

namespace App\Modules;

use Mail;

class MailerModule
{

    public static function sendOrderConfirmation($email, $data) {

        return Mail::send('emails.order_confirmation', $data, function($message) use ($data, $email)
        {
            $message->subject('Confirmation de commande');
            $test_urls = ['http://localhost:8000', 'http://debloquertelephone.seoldiers.com', 'http://198.89.121.209', 'http://dt.crownux.com'];

            if(in_array(url('/'), $test_urls)) {
                $email = 'analizapandac@gmail.com';
                $message->to($email);
            } else {
                $message->to($email)->bcc('deblocage.dev@gmail.com')->bcc('sav.desimlockage@gmail.com');
            }
            $message->from('noreply@debloquertelephone.com', 'Service Clientele');
        });
    }


}
