<?php namespace App\Modules;

use App\Operator;
use App\Price;

class OperatorModule {

	public function getActiveOperators()
	{
		$parent_operators = Operator::select('id', 'name', 'parent_id')->whereStatus(1)->where('parent_id', 0)->orderBy('name')->get();
		$other_two_operators = Operator::select('id', 'name', 'parent_id')->with('parent')->whereStatus(1)->where('parent_id', '!=', 0)->where('name', 'Universal mobile')->orWhere('name', 'Virgin mobile')->get();
		$parent_operators = $parent_operators->merge($other_two_operators);
		$child_operators = Operator::select('id', 'name', 'parent_id')->with('parent')->whereStatus(1)->where('parent_id', '!=', 0)->where('name', '!=', 'Universal mobile')->where('name', '!=', 'Virgin mobile')->orderBy('name')->get();
		return $parent_operators->merge($child_operators);
	}

	public function getOperator($operator_id)
	{
		return Operator::with('parent')->find($operator_id);
	}

	public function getPricing($country, $website_id)
	{
		$pricing = Price::where('country_name', $country)->where('website_id', $website_id)->first()->toArray();
		$operator_prices = array(
			2 =>  $pricing['price_bouygues'],
			47 => $pricing['price_freemobile'],
			14 => $pricing['price_orange'],
			15 => $pricing['price_sfr'],
			'OTHER_OPERATOR' => $pricing['price_other_operator'],
			
			'LG_PROMO' => $pricing['price_lg'],
			'LG_SFR' => $pricing['price_lg_sfr'],
			
			'BLACKBERRY_PROMO' => $pricing['price_blackberry'],
			'BLACKBERRY_SPECIAL' => $pricing['price_blackberry_special'],
			'BLACKBERRY_SFR' => $pricing['price_blackberry_sfr'],
			
			'NOKIA_DCT4' => $pricing['price_nokia_dct4'],
			'NOKIA_BB5' => $pricing['price_nokia_bb5'],
			
			'IPHONE_SFR' => $pricing['price_iphone_sfr'],
			'IPHONE_ORANGE' => $pricing['price_iphone_orange'],
			'IPHONE_BOUYGUES' => $pricing['price_iphone_bouygues'],
			
			'SAMSUNG_SFR' => $pricing['price_samsung_sfr'],
			'SAMSUNG_ORANGE' => $pricing['price_samsung_orange'],
			'SAMSUNG_BOUYGUES' => $pricing['price_samsung_bouygues'],
			'SAMSUNG_OTHER' => $pricing['price_samsung_other'],
			
			'SONYERICSSON_SFR' => $pricing['price_sonyericsson_sfr'],
			'SONYERICSSON_ORANGE' => $pricing['price_sonyericsson_orange'],
			'SONYERICSSON_BOUYGUES' => $pricing['price_sonyericsson_bouygues'],
			
			'SONY_SFR' => $pricing['price_sony_sfr'],
			'SONY_ORANGE' => $pricing['price_sony_orange'],
			'SONY_BOUYGUES' => $pricing['price_sony_bouygues'],
			
			'ALCATEL_SFR' => $pricing['price_alcatel_sfr'],
			'ALCATEL_ORANGE' => $pricing['price_alcatel_orange'],
			'ALCATEL_BOUYGUES' => $pricing['price_alcatel_bouygues'],
			
			'MOTOROLA_SFR' => $pricing['price_motorola_sfr'],
			'MOTOROLA_ORANGE' => $pricing['price_motorola_orange'],
			'MOTOROLA_BOUYGUES' => $pricing['price_motorola_bouygues'],
			
			'HUAWEI_SFR' => $pricing['price_huawei_sfr'],
			'HUAWEI_ORANGE' => $pricing['price_huawei_orange'],
			'HUAWEI_BOUYGUES' => $pricing['price_huawei_bouygues'],
			
			'HTC_SFR' => $pricing['price_htc_sfr'],
			'HTC_ORANGE' => $pricing['price_htc_orange'],
			'HTC_BOUYGUES' => $pricing['price_htc_bouygues']
			
		);

		return $operator_prices;

		//APPLY FORMATTING TO NOKIA PRICE
		// $price_nokia_dct4 = number_format($pricing['price_nokia_dct4'], 2);
		// $price_nokia_bb5 = number_format($pricing['price_nokia_bb5'], 2);
	}

	function isNokiaDct4($model_name)
	{
		return false;
		// $count = Operator::where('name', $model_name)->where('phone_bb5', 'N')->where('manufacturer_id', 34)->count();
		// return $count > 0;
	}

	function getOperatorByName($name) {
		return Operator::where('name', $model_name)->first();
	}

}