<?php namespace App\Modules;

use Omnipay\Omnipay;
use App\Order;

class PaymentModule {

    protected $gateway;

    public function __construct()
    {
        $this->setGateway();
    }

    public function setGateway()
    {
        $this->gateway = Omnipay::create('PayPal_Express');

        //'http://localhost:8000', 
        $test_urls = ['http://debloquertelephone.seoldiers.com', 'http://198.89.121.209', 'http://dt.crownux.com'];


        if(in_array(url('/'), $test_urls)) {

            $this->gateway->setUsername('client2_api1.springrank.com');
            $this->gateway->setPassword('1395994356');
            $this->gateway->setSignature('AFcWxV21C7fd0v3bYYYRCpSSRl31AfMPU-y.ikgpBNyb5x9o.hWMKCYV');
            $this->gateway->setTestMode(true);

        }else {

            $this->gateway->setUsername('luisant.inc_api1.gmail.com');
            $this->gateway->setPassword('RCRBL7KW7GSLWJLL');
            $this->gateway->setSignature('AvzUcvJx7jtqGvdUCUp6Delas0vWAb9StBb5iw6jPd1ibOdz4-sIM4uy');
            $this->gateway->setTestMode(false);

        }
    }

    public function getGetway() 
    {
        return $this->gateway;
    }

    public function checkout($order_id)
    {
        $order = Order::where('order_id', $order_id)->first();

        $cart_items = [];

        $total = 0;

        $test_urls = ['http://localhost:8000', 'http://debloquertelephone.seoldiers.com', 'http://198.89.121.209', 'http://dt.crownux.com'];
        if(in_array(url('/'), $test_urls)) $order->amount = 1.00;

        if(is_object($order)) {
            $total += $order->amount;

            $cart = [
                'price' => $order->amount,
                'name' => '1 Code deblocage '.$order->operator.':'. $order->phone.' '.$order->model.' ('.$order->imei.')'
            ];

          $cart_items[] = $cart;
        }

        $hash_time = $order->datemodified;
        $hash = md5($order->operator . $order->phone . $order->imei . $hash_time);
        $return_url = url('payment-successful').'?hash='.$hash.'&puid='.md5($order_id);
        $cancel_url = url('payment-cancelled');
        $image_url = 'http://dt.crownux.com/images/logo-paypal.png';

        $test_urls = ['http://localhost:8000', 'http://debloquertelephone.seoldiers.com', 'http://198.89.121.209', 'http://dt.crownux.com'];
        if(in_array(url('/'), $test_urls)) $total = 1.00;

        $settings = [
            'amount' => $total,
            'currency' => 'EUR',
            'returnUrl' => $return_url,
            'cancelUrl' => $cancel_url,
            'logoImageUrl' => $image_url
        ];

        if ($order->express) {
            $settings['solutionType'] = 'Sole';
            $settings['landingPage'] = 'Billing';
        } else {
            $settings['landingPage'] = 'Login';
        }

        $response = $this->gateway->purchase($settings)->setItems($cart_items)->send();

        if ($response->isSuccessful()) {
            // payment was successful: update database
            return print_r($response);

        } elseif ($response->isRedirect()) {
            // redirect to offsite payment gateway
            return $response->redirect();
        } else {
            // payment failed: display message to customer
            return $response->getMessage();
        }

    }


}