<?php namespace App\Modules;

use App\Price;

class PriceModule {

	public function getPrice($pricing_criterias = [], $operator_prices = [], $price)
	{
		$phone = $pricing_criterias['phone'];
		$model = $pricing_criterias['model'];
		$operator = $pricing_criterias['operator'];
		$parent_operator_name = $pricing_criterias['parent_operator_name'];

		//CHECK FOR BLACKBERRY PROMO PRICE
		if(preg_match("/Blackberry/i", $phone)){
			if(preg_match("/Q5/i", $model) || preg_match("/Q10/i", $model) || preg_match("/Z10/i", $model) || preg_match("/Z30/i", $model)){
				if(intval($operator_prices['BLACKBERRY_SPECIAL']) > 0){
					$price = $operator_prices['BLACKBERRY_SPECIAL'];
				}
			}
			else{
				if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
					if(intval($operator_prices['BLACKBERRY_SFR']) > 0){
						$price = $operator_prices['BLACKBERRY_SFR'];
					}
				}
				else{
					if(intval($operator_prices['BLACKBERRY_PROMO']) > 0){
						$price = $operator_prices['BLACKBERRY_PROMO'];
					}
				}
			}
		}
		
		//CHECK FOR LG PROMO PRICE
		if(preg_match("/LG/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['LG_SFR']) > 0){
					$price = $operator_prices['LG_SFR'];
				}
			}
			else{
				if(intval($operator_prices['LG_PROMO']) > 0){
					$price = $operator_prices['LG_PROMO'];
				}	
			}					
		}	
		
		//CHECK FOR IPHONE PROMO PRICE
		if(preg_match("/IPHONE/i", $phone) or preg_match("/APPLE/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['IPHONE_SFR']) > 0){
					$price = $operator_prices['IPHONE_SFR'];
				}
			}
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['IPHONE_ORANGE']) > 0){
					$price = $operator_prices['IPHONE_ORANGE'];
				}
			}
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['IPHONE_BOUYGUES']) > 0){
					$price = $operator_prices['IPHONE_BOUYGUES'];
				}
			}
		}	
		
		//CHECK FOR SAMSUNG PROMO PRICE
		if(preg_match("/SAMSUNG/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['SAMSUNG_SFR']) > 0){
					$price = $operator_prices['SAMSUNG_SFR'];
				}
			}		
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['SAMSUNG_ORANGE']) > 0){
					$price = $operator_prices['SAMSUNG_ORANGE'];
				}
			}		
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['SAMSUNG_BOUYGUES']) > 0){
					$price = $operator_prices['SAMSUNG_BOUYGUES'];
				}
			}									
			else{
				if(intval($operator_prices['SAMSUNG_OTHER']) > 0){
					$price = $operator_prices['SAMSUNG_OTHER'];
				}
			}		
		}
						
		//CHECK FOR SONY & SONYERICSSON PROMO PRICE
		if(preg_match("/SONY/i", $phone)){
			if(preg_match("/SONY\s+ERICSSON/i", $phone)){
				//SONYERICSSON PHONES
				if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
					if(intval($operator_prices['SONYERICSSON_SFR']) > 0){
						$price = $operator_prices['SONYERICSSON_SFR'];
					}
				}
				elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
					if(intval($operator_prices['SONYERICSSON_ORANGE']) > 0){
						$price = $operator_prices['SONYERICSSON_ORANGE'];
					}
				}
				elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
					if(intval($operator_prices['SONYERICSSON_BOUYGUES']) > 0){
						$price = $operator_prices['SONYERICSSON_BOUYGUES'];
					}
				}
			}
			else{
				//SONY PHONES
				if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
					if(intval($operator_prices['SONY_SFR']) > 0){
						$price = $operator_prices['SONY_SFR'];
					}
				}
				elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
					if(intval($operator_prices['SONY_ORANGE']) > 0){
						$price = $operator_prices['SONY_ORANGE'];
					}
				}
				elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
					if(intval($operator_prices['SONY_BOUYGUES']) > 0){
						$price = $operator_prices['SONY_BOUYGUES'];
					}
				}
			}	
		}
		
		//CHECK FOR ALCATEL PROMO PRICE
		if(preg_match("/ALCATEL/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['ALCATEL_SFR']) > 0){
					$price = $operator_prices['ALCATEL_SFR'];
				}
			}
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['ALCATEL_ORANGE']) > 0){
					$price = $operator_prices['ALCATEL_ORANGE'];
				}
			}
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['ALCATEL_BOUYGUES']) > 0){
					$price = $operator_prices['ALCATEL_BOUYGUES'];
				}
			}
		}
		
		//CHECK FOR MOTOROLA PROMO PRICE
		if(preg_match("/MOTOROLA/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['MOTOROLA_SFR']) > 0){
					$price = $operator_prices['MOTOROLA_SFR'];
				}
			}
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['MOTOROLA_ORANGE']) > 0){
					$price = $operator_prices['MOTOROLA_ORANGE'];
				}
			}
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['MOTOROLA_BOUYGUES']) > 0){
					$price = $operator_prices['MOTOROLA_BOUYGUES'];
				}
			}
		}
		
		//CHECK FOR HUAWEI PROMO PRICE				
		if(preg_match("/HUAWEI/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['HUAWEI_SFR']) > 0){
					$price = $operator_prices['HUAWEI_SFR'];
				}
			}
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['HUAWEI_ORANGE']) > 0){
					$price = $operator_prices['HUAWEI_ORANGE'];
				}
			}
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['HUAWEI_BOUYGUES']) > 0){
					$price = $operator_prices['HUAWEI_BOUYGUES'];
				}
			}					
		}								
		
		//CHECK FOR HTC PROMO PRICE
		if(preg_match("/HTC/i", $phone)){
			if(preg_match("/SFR/i", $operator) || preg_match("/SFR/i", $parent_operator_name)){
				if(intval($operator_prices['HTC_SFR']) > 0){
					$price = $operator_prices['HTC_SFR'];
				}
			}
			elseif(preg_match("/ORANGE/i", $operator) || preg_match("/ORANGE/i", $parent_operator_name)){
				if(intval($operator_prices['HTC_ORANGE']) > 0){
					$price = $operator_prices['HTC_ORANGE'];
				}
			}
			elseif(preg_match("/BOUYGUES/i", $operator) || preg_match("/BOUYGUES/i", $parent_operator_name)){
				if(intval($operator_prices['HTC_BOUYGUES']) > 0){
					$price = $operator_prices['HTC_BOUYGUES'];
				}
			}					
		}	
		
		return $price;
	}
}