<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    protected $table = 'tb_users';

    // Eloquent will assume that each table has a primary key column named id. You may define a $primaryKey property to override this convention.
    // protected $primaryKey = 'uid';  // some issues with using table tmusers or users
    protected $primaryKey = 'user_id';

    // The additional properties in the model that are dates.
    // http://laravel.com/docs/5.1/eloquent-mutators#date-mutators
    protected $dates = ['lastlogin'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
}
