$(document).ready(function() {

	$('#filter-dropdown').on('change', function() {
		var type = $(this).val();
		console.log(type);
		if(type == 'yearly') {
			$('.custom-filter-dp').hide();
			$('.monthly-filter-dp').hide();
			//$('.year-filter-dp').fadeIn();
			$('.year-filter-dp').css('display', 'inline-block');
		} else if(type == 'monthly') {
			$('.custom-filter-dp').hide();
			//$('.monthly-filter-dp').fadeIn();
			$('.monthly-filter-dp').css('display', 'inline-block');
			$('.year-filter-dp').hide();
		}else {
			//$('.custom-filter-dp').fadeIn();
			$('.custom-filter-dp').css('display', 'inline-block');
			$('.monthly-filter-dp').hide();
			$('.year-filter-dp').hide();
		}
	});

	$(".btn-edit-address").click(function(){
   		$(this).closest('table').find('.btn-edit-address').show();
   		$(this).closest('table').find('.form-address-wrapper').hide();
   		$(this).hide();
   		$(this).parent('td').find('.form-address-wrapper').show();
   	});

    $(".btn-edit-name").click(function(){
        $(this).parent('.name-wrapper').hide();
        $(this).parent('.name-wrapper').parent('td').find('.form-name-wrapper').show();
    });

    $('#modalEditProfile form').on('submit', function(e) {
    	var password = $(this).find('[name="password"]').val();
    	var conf_password = $(this).find('[name="conf_password"]').val();
    	if(password !== conf_password) {
    		$(this).find('[name="password"]').closest('.form-group').addClass('has-error');
    		$(this).find('[name="conf_password"]').closest('.form-group').addClass('has-error');
    		e.preventDefault();
    	} else {
    		$(this).find('[name="password"]').closest('.form-group').removeClass('has-error');
    		$(this).find('[name="conf_password"]').closest('.form-group').removeClass('has-error');
    	}
    });

    $(".btn-ship-order").click(function(){
        var id = $(this).data('id');

        $.post(window.Laravel.BASE_URL + '/orders/ship', { _token: window.Laravel.csrfToken, id: id }, function(data) {
	        console.log(data);
	        toastr.success('Order status was changed successfully to Shipped.', 'Success', { preventDuplicates: true });
	        document.location.reload(true);
	    })
	    .fail(function(err) {
	        if(err.status == 401) {
	            window.location.href = window.Laravel.BASE_URL + '/login';
	        }

	        toastr.error('An error occured while trying to ship order', 'Error!', { preventDuplicates: true });

	    });
    });

    $(".btn-remail-order").click(function(){
        var id = $(this).data('id');

        $.post(window.Laravel.BASE_URL + '/orders/remail', { _token: window.Laravel.csrfToken, order_id: id }, function(data) {
	        console.log(data);
	        toastr.success('Order status was changed successfully remailed.', 'Success', { preventDuplicates: true });
	        document.location.reload(true);
	    })
	    .fail(function(err) {
	        if(err.status == 401) {
	            window.location.href = window.Laravel.BASE_URL + '/login';
	        }

	        toastr.error('An error occured while trying to remail order', 'Error!', { preventDuplicates: true });

	    });
    });
	
});