(function ($) {

    "use strict";

    $(function () {
      $('[data-toggle="tooltip"]').tooltip();
    });

    jQuery('.latest-purchase').html(currentBuyerCounter());

    $(window).scroll(function() {     
        var scroll = $(window).scrollTop();
        if (scroll > 0) {
            $(".mainmenu-area").addClass("active");
        }
        else {
            $(".mainmenu-area").removeClass("active");
        }
    });

    $('.panel-collapse').on('show.bs.collapse', function () {
        $(this).siblings('.panel-heading').addClass('active');
    });

    $('.panel-collapse').on('hide.bs.collapse', function () {
        $(this).siblings('.panel-heading').removeClass('active');
    });
    
    $(".carousel-inner .item:first-child").addClass("active");
    /* Mobile menu click then remove
    ==========================*/
    $(".mainmenu-area #mainmenu li a").on("click", function () {
        $(".navbar-collapse").removeClass("in");
    });
    /*WoW js Active
    =================*/
    new WOW().init({
        mobile: true,
    });
    /* Scroll to top
    ===================*/
    $.scrollUp({
        scrollText: '<i class="icofont icofont-arrow-up"></i>',
        easingType: 'linear',
        scrollSpeed: 900,
        animation: 'fade'
    });


    var client_photo2 = $('.client_details');
    client_photo2.owlCarousel({
        loop: true,
        margin: 30,
        autoplay: false,
        center: true,
        dots: true,
        autoplayTimeout: 4000,
        smartSpeed: 600,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            992: {
                items: 1
            }
        }
    });
   
    $('.client_nav .testi_next').on('click', function () {
        client_photo.trigger('next.owl.carousel');
    });
    $('.client_nav .testi_prev').on('click', function () {
        client_photo.trigger('prev.owl.carousel');
    });

    $('#form-phone').on('change', function() {
        var manufacturer = this.value;

        $.post(window.Laravel.BASE_URL + '/models', {manufacturer: manufacturer}, function(response) {
            var availableModels = [];
            $.each(response.models, function(key, value) {
                availableModels.push(value.name);
            });
            $( "#form-model" ).autocomplete({
              source: availableModels
            });
        })
    });
   

    /* Preloader Js
    ===================*/
    $(window).on("load", function () {
        $('.preloader').fadeOut(500);
    });
})(jQuery);