// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeline', 'timelineEnd', 'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];

        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

// Place any jQuery/helper plugins in here.

$('.smoth-scroll a[href*="#"]:not([href="#"])').click(function () {
    if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
        var target = $(this.hash);
        target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
        if (target.length) {
            $('html, body').animate({
                scrollTop: target.offset().top - 140
            }, 1000);
            $(this).closest('ul').find('li.active').removeClass('active');
            $(this).closest('li').addClass('active');
            return false;
        }
    }
});

$('a.btn-focus-form[href*="#"]:not([href="#"])').click(function () {
    if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
        var target = $(this.hash);
        target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
        if (target.length) {
            $('html, body').animate({
                scrollTop: target.offset().top - 250
            }, 1000);

            $('#form-phone').focus();
            return false;
        }
    }
});


$(document).ready(function() {
    var urlHash = window.location.href.split("#")[1];
    if (urlHash &&  $('#' + urlHash).length )
    $('html,body').animate({
      scrollTop: $('#' + urlHash).offset().top - 140
    }, 1000);
    
    var url = window.Laravel.BASE_URL + '#' + urlHash;

    if($('.smoth-scroll a[href="' + url +'"]').length) {
        $('.smoth-scroll a[href="' + url +'"]').closest('ul').find('li.active').removeClass('active');
        $('.smoth-scroll a[href="' + url +'"]').closest('li').addClass('active');
    }

    
});
