@extends('layouts.app')

@section('content')
<div id="page-overlay"></div>
<div id="page-overlay-color"></div>
<div id="content-wrapper">
    <div class="container-fluid height-100">
        <div class="row height-100">
            <div class="col-md-12 height-100">
                <div id="login-page">
                    <div class="text-center login-logo-wrapper">
                        <img src="{{ url('images/logo.png') }}" alt="DebloquerTelephone Logo">
                    </div>
                    @if (session('status'))
                        <div class="alert alert-success">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-success">
                            {{ session('error') }}
                        </div>
                    @endif
                    <form class="" role="form" method="POST" action="{{ route('password.email') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <label for="email" class="control-label">E-Mail Address</label>
                            <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required autofocus>
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-green">
                                <i class="fa fa-btn fa-sign-in"></i>  Send Password Reset Link
                            </button>
                        </div>
                        <p><a class="btn-link" href="{{ route('login') }}">Login here </a>if you already have an account.</p>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
