@extends('layouts.public')

@section('metatags')
<title>Commande | Debloquer Telephone</title>
@endsection

@section('content')
    <!--[if lt IE 8]>
    <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->


    <!-- Header-area -->
    <header class="header-area relative plain-bg" id="home">
    	<!-- Mainmenu-Area -->
    	<nav class="navbar navbar-default mainmenu-area navbar-fixed-top smoth-scroll">
    		<div class="container">
    			<div class="navbar-header">
    				<a href="{{ url('/') }}" class="navbar-brand"><img src="images/logo.png" alt=""></a>
    				
    			</div>
    			<div class="navbar-collapse collapse" id="mainmenu">
    				<div id="website-secured-proof" class="center-block text-right">
                        <ul class="list-unstyled">
                            <li><div class="secured-logo norton"></div></li>
                            <li><div class="secured-logo verisign"></div></li>
                            <li><div class="secured-logo truste"></div></li>
                            <li><div class="secured-logo paypal"></div></li>
                        </ul>
                    </div>
    			</div>
    		</div>
    	</nav>
    	<!-- Mainmenu-Area / -->
    	<div class="space-140" id="heading-content-separator"></div>
    </header>

    	<section id="checkout">
    		<div class="container">
    			<div class="row">
    				<div class="col-sm-12 col-md-9 center-block">
    					<h1 id="subpage-title" class="text-center">Commande</h1>
                        <div class="space-20"></div>
    				</div>
    			</div>
    			<div class="row">
    				<div class="col-md-5">
    					<div id="receipt">
    						<div class="receipt-heading">
                                <h4 class="section-title">DÉBLOQUER VOTRE TÉLÉPHONE MOBILE EN QUELQUES MINUTES</h4>                  
                            </div>  
    						<div class="receipt-body">
    							<div class="row row-details">
	    							<div class="col-md-6">
	    								<div class="text-label">CODE DÉBLOCAGE</div>
	    							</div>
	    							<div class="col-md-6">
	    								<div class="text-green">{{ $order->operator }}</div>
	    							</div>
	    						</div>
	    						<div class="row row-details">
	    							<div class="col-md-6">
	    								<div class="text-label">MARQUE ET MODÈLE</div>
	    							</div>
	    							<div class="col-md-6">
	    								<div class="text-green">{{ $order->phone }} {{ $order->model }}</div>
	    							</div>
	    						</div>
	    						<div class="row row-details">
	    							<div class="col-md-6">
	    								<div class="text-label">IMEI</div>
	    							</div>
	    							<div class="col-md-6">
	    								<div class="text-green">{{ $order->imei }}</div>
	    							</div>
	    						</div>
    						</div>
    						<div class="receipt-footer">
    							<div class="row">
                                    <div class="col-md-6">
                                        <div class="total-label text-extrabold">Total</div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="text-green text-extrabold total">€ {{ $order->amount }}</div>
                                    </div>
                                </div>  
    						</div>
    					</div>
    					
    				</div>
                    <!-- end col-md-5 -->
                    <!-- start col-md-7 -->
                    <div class="col-md-7">
                       <div id="checkout-form">
                            <h4 class="section-title">INFORMATIONS PERSONNELLES</h4>
                            <form action="{{ url('checkout') }}" id="form-checkout" method="post">
                                {{ csrf_field() }}
                                <input type="hidden" name="payment_method">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group {{ $errors->has('firstname') ? ' has-error' : '' }}">
                                            <label>Prénom</label>
                                            <input type="text" class="form-control" value="{{ strlen($order->firstname) > 0 ? $order->firstname : old('firstname') }}" placeholder="Entrez votre prénom" name="firstname" required>
                                            @if ($errors->has('firstname'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('firstname') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group {{ $errors->has('lastname') ? ' has-error' : '' }}">
                                            <label>Nom de famille</label>
                                            <input type="text" class="form-control" value="{{ strlen($order->lastname) > 0 ? $order->lastname : old('lastname') }}" placeholder="Entrez votre nom de famille" name="lastname" required>
                                            @if ($errors->has('lastname'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('lastname') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="checkbox">
                                            <label>
                                            <input type="checkbox" @if($order->sms_included != 0) checked="checked" @endif name="is_sms_included">
                                            SMS (Facultatif) <br />
                                            envoi de votre code via texto pour 1€
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-12" id="sms_included_wrapper" @if($order->sms_included == 0) style="display: none;"  @endif>
                                        <div class="form-group">
                                            <input type="number" @if($order->sms_included != 0) value="{{ $order->sms_included }}" @endif class="form-control" placeholder="Entrez ici votre numero de portable" name="phone_number">
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="space-20"></div>
                            <h4 class="section-title">MODE DE PAIEMENT</h4>                        
                            <div class="space-10"></div>
                            <div class="row checkout-buttons">
                                <div class="col-md-6">
                                    <button type="button" data-method="paypal" class="bttn btn-blue btn-pay">
                                        <!-- <i class="icofont icofont-paypal-alt"></i> -->
                                        <img src="images/paypal-payment.png" class="payment-option-img" alt="paypal payment">
                                        Paypal
                                    </button>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" data-method="credit-card" class="bttn btn-orange btn-pay"> 
                                        <img src="images/credit-cards-payment.png" class="payment-option-img credit-card" alt="credit cards payment">
                                       <!-- <i class="icofont icofont-credit-card"></i> -->
                                        Carte de Crédit
                                    </button>
                                </div>
                           </div>
                        </div>
                    </div>        
                    <!-- end col-md-7 -->
    			</div>
    		</div>
    	</section>

    	<div class="space-85"></div>

@endsection

@section('custom_js')
    <script>
        $(document).ready(function() {
            $('.btn-pay').click(function(event) {
                var method = $(this).data('method');
                $('#form-checkout').find('[name="payment_method"]').val(method);
                event.preventDefault();
                document.getElementById('form-checkout').submit();
            });

            $('*[name="is_sms_included"]').change(function(e) {
                if(this.checked) {
                    $(this).closest("form").find('#sms_included_wrapper').show();
                } else {
                    $(this).closest("form").find('#sms_included_wrapper').hide();
                }
            });
        });
    </script>
@endsection