@extends('layouts.public')

@section('metatags')
<title>Debloquer Telephone</title>
@endsection

@section('content')
    <!--[if lt IE 8]>

            <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>

        <![endif]-->

    <header class="header-area relative plain-bg" id="accueil">
        @include('partials.topmenu')
        <!--Header-Text-->
        <div id="atf">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-6  full-tablet-portrait">
                        <div id="form-wrapper">
                            <h1 class="form-title">DÉBLOQUEZ VOTRE TÉLÉPHONE PORTABLE DE CHEZ VOUS EN <span class="text-green">3 MINUTES</span>!</h1>
                            <p class="form-subtitle hidden-xs">
                            Notre code de déverrouillage est garanti à 100 %, donc dans le cas improbable où cela ne fonctionne pas, vous recevrez un remboursement complet.
                            </p>
                            <div class="space-5"></div>
                            <form action="{{ url('add-to-cart') }}" method="post" id="order-form">
								{{ csrf_field() }}
                                <div class="form-group form-inline {{ $errors->has('phone') ? ' has-error' : '' }}">
                                    <label for="">Marque</label>
                                    <select name="phone" class="form-control" id="form-phone" required>
                                        <option value="">Sélectionnez votre marque </option>
                                        <?php $count = 0;  ?>
                                        @foreach($manufacturers as $key => $manufacturer)

                                        <?php $count++;  ?>
                                        @if($count <= 5)
                                        <option style="font-weight:bold;" {{ (old("phone") == $manufacturer->name ? "selected":"") }} @if(is_object($selected_manufacturer) && $selected_manufacturer->name == $manufacturer->name) selected="selected" @endif  value="{{ $manufacturer->name }}">{{ $manufacturer->name }}</option>
                                        @else
                                        <option {{ (old("phone") == $manufacturer->name ? "selected":"") }}  @if(is_object($selected_manufacturer) && $selected_manufacturer->name == $manufacturer->name) selected="selected" @endif value="{{ $manufacturer->name }}">{{ $manufacturer->name }}</option>
                                        @endif

                                        @if($count == 5)
                                        <option value="" disabled="disabled">----------------------------------------------------</option>
                                        @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('phone'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="form-group form-inline {{ $errors->has('model') ? ' has-error' : '' }}">
                                    <label for="">Modéle</label>
                                    <div class="input-group">
                                        <input type="text" id="form-model" value="{{ old('model') }}" name="model" class="form-control" placeholder="Entrez votre modèle de téléphone"required />
                                        <span class="input-group-addon"><i data-toggle="tooltip" data-placement="right" title="Si vous ne trouvez pas votre modèle de téléphone dans la liste ce n`est pas grave, veuillez simplement taper manuellement le nom complet de votre modèle dans la case, nous débloquons tous les modèles de téléphones sur le marché." class="icofont icofont-info-circle"></i></span>
                                    </div>
                                    @if ($errors->has('model'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('model') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="form-group form-inline {{ $errors->has('operator_id') ? ' has-error' : '' }}">
                                    <label for="">Opérateur</label>
                                    <select name="operator_id" class="form-control" id="" required>
                                           	<option value="">Votre ancien opérateur</option>
                                            <?php $count = 0;  ?>
                                           	@foreach($operators as $key => $operator)
                                                <?php $count++;  ?>
                                           		@if($operator->parent_id == 0 || $operator->name == 'Virgin mobile' || $operator->name == 'Universal mobile')
												<option {{ (old("operator_id") == $operator->id ? "selected":"") }} style="font-weight:bold;" value="{{ $operator->id }}">{{ $operator->name }}</option>
												@else
												<option {{ (old("operator_id") == $operator->id ? "selected":"") }}  value="{{ $operator->id }}">{{ $operator->name }} ({{ $operator->parent->name }})</option>
												@endif

                                                @if($count == 5)
                                                <option value="" disabled="disabled">----------------------------------------------------</option>
                                                @endif
		                                    @endforeach

                                    </select>
                                    @if ($errors->has('operator_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('operator_id') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group form-inline {{ $errors->has('imei') ? ' has-error' : '' }}">
                                    <label for="">Code IMEI</label>
                                    <div class="input-group">
                                        <input type="number" name="imei" value="{{ old('imei') }}" class="form-control" placeholder=" Entrez votre numéro IMEI" required>
                                        <span class="input-group-addon"><i data-toggle="tooltip" data-placement="right" title="Appelez le code IMEI. Vous pouvez trouver le numéro IMEI/MEID de presque n'importe quel téléphone, simplement en appelant le code universel. Composez le *#06#. Normalement, vous ne devrez pas appuyer sur la touche d'appel ou d'envoi, car le numéro IMEI/MEID apparaîtra dès que vous avez fini d'introduire le code." class="icofont icofont-info-circle"></i></span>
                                    </div>
                                    @if ($errors->has('imei'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('imei') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group form-inline {{ $errors->has('email') ? ' has-error' : '' }}">
                                    <label for="">Email</label>
                                    <input type="email" class="form-control" value="{{ old('email') }}" name="email" placeholder=" Entrez votre courriel" required>
                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <div class="checkbox">
                                        <label>
                                        <input type="checkbox" required>J'ai lu et j'accepte les <span data-toggle="modal" data-target="#modal-tos" class="text-green text-bold"> conditions générales de vente</span> 
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="bttn btn-orange">DEBLOQUER MON TÉLÉPHONE</button>
                                </div>
                            </form>

                            <div class="space-10"></div>
                            <div id="website-secured-proof" class="center-block text-center">
                                <ul class="list-unstyled">
                                    <li><div class="secured-logo norton"></div></li>
                                    <li><div class="secured-logo verisign"></div></li>
                                    <li><div class="secured-logo truste"></div></li>
                                    <li><div class="secured-logo paypal"></div></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="cl-xs-12 col-sm-6 hidden-xs hidden-tablet-portrait">
                        <p class="text-center" id="phones-wrapper">
                            <img src="{{ asset('images/home-phones.png') }}" class="img-responsive" alt="">
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!--Header-Text / -->

        <div id="recent-purchases-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-md-offset-6">
                        <h4 class="text-white text-normal section-title">DÉJA MAINTENANT PLUS DE 117,514 TÉLÉPHONES DÉSIMLOCKÉS!</h4>
                        <div id="purchase-ticker">
                            <div class="media">
                                <div class="media-left">
                                    <img src="{{ asset('images/purchased-operator-orange.png') }}" alt="">
                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading">TÉLÉPHONE BLACKBERRY DÉBLOQUÉ!</h4>
                                    <p class="purchase-details">‘Guena R’ a maintenant son ‘Blackberry 8520’ déverrouillé ! </p>
                                    <p class="text-right no-margin-bottom purchase-date">il y a 10 minutes</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Header-area / -->

    <!-- About-area -->
    <section class="relative hidden-xs hidden-tablet-portrait" id="reviews">
        <div class="container">
            <div class="row">
                <div class="col-md-2 col-md-offset-1">
                    <p id="badge-wrapper"><img class="img-responsive" src="{{ asset('images/average-customer-review-badge.png') }}" alt=""></p>
                </div>
                <div class="col-md-6">
                    <div id="review-sites-wrapper">
                        <h4 class="text-green text-bold font-secondary">7614 AVIS CERTIFIÉS PAR </h4>
                        <ul class="list-unstyled review-sites first">
                            <li>
                                <img src="{{ asset('images/dismoiou.png') }}" alt="dismoiou logo">
                            </li>
                        </ul>

                        <ul class="list-unstyled review-sites second">
                            <li>
                                <img src="{{ asset('images/trustpilot.png') }}" alt="trustpilot logo">
                            </li>
                        </ul>

                        <div class="space-10"></div>
                        <p class="text-green text-md">
                            <a href="#temoignages">
                             Voir tous les témoignages
                             <i class="icofont icofont-search"></i></a>
                        </p>
                    </div>
                </div>

                <div class="col-md-3 text-left">
                    <h5 class="text-green text-bold font-secondary">Avis des clients</h5>
                    <p class="text-sm">7504 avis</p>
                    <img src="{{ asset('images/customer-reviews.png') }}" alt="customer reviews">
                    
                </div>
            </div>
        </div>
    </section>
    <!-- About-area / -->

    <!-- Feature-area -->

    <section class="relative bg-green text-white benefits" id="benefices">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-4 hidden-xs hidden-tablet-portrait">
                    <div class="text-left image-wrapper">
                        <img src="{{ asset('images/unlocked-iphone.png') }}" alt="">
                    </div>
                </div>

                <div class="col-xs-12 col-sm-6 col-md-8 text-content full-tablet-portrait">
                    <h4 class="page-title">AVANTAGES DU DÉVERROUILLAGE PAR CODE DE VOTRE TÉLÉPHONE PORTABLE</h4>
                    <p class="page-subtitle">L‘action de déverrouiller votre téléphone portable va littéralement «libérer» votre téléphone de votre fournisseur actuel, vous laissant libre de choisir n'importe quel fournisseur français ou étranger.</p>
                    <ul class="list-unstyled feature">
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Vous pourrez immédiatement insérer toutes les cartes SIM françaises et étrangères dans votre portable sans aucune restriction.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>C‘est la manière la plus simple et la plus rapide pour déverrouiller un téléphone portable.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Vous déverrouillez à partir de chez vous, nul besoin de vous déplacer.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Vous serez en mesure de garder tous vos paramètres personnalisés actuels.</p>
                            </div>
                        </li>

                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Le déverrouillage est permanent et si vous n‘êtes pas satisfait nous vous remboursons à 100%.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>La garantie d'origine de votre téléphone portable restera intacte.</p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Feature-area / -->

    <!--Price-Table-->

    <section class="relative text-white bg-dark-green pricing" id="prix">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-md-10 center-block text-center">
                    <h3 class="page-title">TOP OPÉRATEURS MOBILES FRANÇAIS</h3>
                    <div class="space-10"></div>
                    <p class="page-subtitle">Avec toutes les nouvelles offres SFR, Orange, B&You, etc., pourquoi ne pas en profiter ? Réduisez vos factures de GSM et donnez-vous les moyens de pouvoir choisir librement votre opérateur réseau.</p>
                </div>
            </div>
            <div class="row pricing-boxes-wrapper">
                <div class="col-md-8 center-block">
                    <div class="row">
                        <div class="col-xs-12 col-sm-4 col-md-4">
                            <div class="well-ef single-price">
                                <div class="price-body text-center">
                                    <p class="img"><img src="{{ asset('images/price-orange.png') }}" alt=""></p>
                                    <p class="price">15.90 <span class="superscript">€</span><span class="text-green text-note">**</span></p>
                                    <p class="vat-note">TTC</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-4 col-md-4">
                            <div class="well-ef single-price">
                                <div class="price-body text-center">
                                    <p class="img"><img src="{{ asset('images/price-sfr.png') }}" alt=""></p>
                                    <p class="price">19.90 <span class="superscript">€</span><span class="text-green text-note">**</span></p>
                                    <p class="vat-note">TTC</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-4 col-md-4">
                            <div class="well-ef single-price">
                                <div class="price-body text-center">
                                    <p class="img"><img src="{{ asset('images/price-bouygues.png') }}" alt=""></p>
                                    <p class="price">15.90 <span class="superscript">€</span><span class="text-green text-note">**</span></p>
                                    <p class="vat-note">TTC</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-sm-10 center-block text-center">
                    <p class="vat-explanation">** Les prix peuvent varier en fonction des opérateurs et des modèles de téléphone</p>
                    <div class="space-20"></div>
                    <a href="#form-model" class="bttn btn-light-orange btn-focus-form">DEBLOQUER MON TÉLÉPHONE</a>
                </div>
            </div>
        </div>
    </section>

    <!--Price-Table / -->

    @include('modals.tos')
    @include('partials.testimonials')
    @include('partials.track-order-form')
    @include('partials.brands')
    @include('partials.footer-cta')
    @include('partials.footer')

@endsection
