<?php 
    $cta = 'LE DÉBLOCAGE DE MON IPHONE';
    $cta_class = 'font-smaller';
?>
@extends('landingpages.templates.brand')

@section('head')
<title>{{ ucwords(mb_strtolower($cta)) }} | Debloquer Telephone</title>
@endsection

@section('form')
<h1 class="form-title">EFFECTUEZ EN MOINS DE 5 MINUTES LE DÉBLOCAGE DE VOTRE IPHONE</h1>
<p class="form-subtitle hidden-xs">Grâce à notre code de déblocage en ligne, vous êtes en mesure de désimlocker votre iPhone rapidement depuis chez vous. Satisfait ou 100% remboursé.</p>
@include('landingpages.partials.form')
@endsection

@section('brand')
<h2 class="landingpage-subtitle">FAIRE LE DÉBLOCAGE DE VOTRE IPHONE FACILEMENT AVEC UNE MÉTHODE SÛRE</h2>
<div class="row">
    <div class="col-md-6 center-block">
        <div class="well-ef single-price">
            <div class="price-body text-center">
                <p class="img"><img src="{{ asset('images/brands/small/apple.png') }}" alt="Apple"></p>
                <p class="price">15.90 <span class="superscript">€</span><span class="text-green text-note">**</span></p>
                <p class="vat-note">TTC</p>
            </div>
        </div>
    </div>
</div>
@endsection

@section('content')
  	<!-- Feature-area -->
    <section class="relative bg-dark-green text-white" id="features">
        <div class="space-50 hidden-xs"></div>
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-4 hidden-xs hidden-tablet-portrait">
                    <div class="space-60"></div>
                    <div class="text-left">
                        <img src="{{ asset('images/unlocked-iphone.png') }}" alt="">
                    </div>
                </div>
                <div class="col-xs-12 col-sm-6 col-md-8 text-content full-tablet-portrait">
                    <div class="space-20 hidden-md  hidden-tablet-portrait"></div>
                    <h4 class="page-title">RÉALISEZ LE DÉBLOCAGE EN 3 MINUTES DE VOTRE IPHONE POUR OBTENIR CES AVANTAGES :</h4>
                    <div class="space-5"></div>
                    <ul class="list-unstyled feature">
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Insérez la carte SIM d’un opérateur français ou étranger dans votre iPhone.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Bénéficiez d’une méthode facile et rapide pour le déblocage de votre iPhone.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Effectuez le déblocage de votre iPhone depuis votre domicile ou depuis votre lieu de travail avec notre code en ligne.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Payez moins cher que chez un opérateur et économisez de l’argent pour faire le déblocage de votre iPhone.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Réalisez le déblocage de votre iPhone pour de bon. Si vous n’êtes pas satisfait, nous vous remboursons entièrement.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Notre méthode simple et fiable pour le déblocage de votre iPhone ne représente aucun risque pour la garantie de votre appareil.</p>
                            </div>
                        </li>
                    </ul>
                    <div class="space-20"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- Feature-area / -->

    <!--Client-Area-->
    <section class="relative bg-dirty-white" id="testimonials">
        <div class="space-70"></div>
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="page-title text-green text-bold">QUEL NOS CLIENTS DITES</h3>
                </div>
                <div class="space-20"></div>
            </div>
            <div class="row">
                <div class="col-xs-12 col-md-8 col-md-offset-2 text-center">
                    <div class="client-details-content">
                        <div class="client_details">
                        	@foreach($testimonials as $key => $testimonial)
							<div class="item">
                                <q>
                                    <span class="opening-quote">«</span>
                                    <span class="testimonial">« {{ $testimonial->content }} »</span>
                                </q>
                                <p class="ratings-wrapper">
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star" aria-hidden="true"></i>
                                </p>
                                <h5 class="text-green text-normal">{{ $testimonial->author }}, {{ $testimonial->date }}</h5>
                                <p class="text-sm">{{ $testimonial->place }}</p>
                            </div>
                        	@endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="space-100"></div>
    </section>
    <!--Client-Area / -->
@endsection