<?php 
    $cta = 'LE DÉBLOCAGE DE MON TÉLÉPHONE UNIVERSAL MOBILE';
    $cta_class = 'font-smaller';
?>
@extends('landingpages.templates.operator')

@section('head')
<title>{{ ucwords(mb_strtolower($cta)) }} | Debloquer Telephone</title>
@endsection

@section('form')
<h1 class="form-title">EFFECTUEZ LE DÉBLOCAGE DEPUIS CHEZ VOUS DE VOTRE TÉLÉPHONE UNIVERSAL MOBILE</h1>
<p class="form-subtitle hidden-xs">Obtenez notre code de déblocage en ligne pour désimlocker votre portable Universal Mobile rapidement. Satisfait à 100% ou remboursé.</p>
@include('landingpages.partials.form')
@endsection

@section('brand')
<h2 class="landingpage-subtitle">RÉALISER LE DÉBLOCAGE DE VOTRE TÉLÉPHONE UNIVERSAL MOBILE AVEC NOTRE MÉTHODE SIMPLE ET RAPIDE</h2>
<div class="row">
    <div class="col-md-6 center-block">
        <div class="well-ef single-price">
            <div class="price-body text-center">
                <p class="img"><img src="{{ asset('images/brands/small/'.$name.'.png') }}" alt="{{ $name }}"></p>
                <p class="price">15.90 <span class="superscript">€</span><span class="text-green text-note">**</span></p>
                <p class="vat-note">TTC</p>
            </div>
        </div>
    </div>
</div>
@endsection

@section('content')
  	<!-- Feature-area -->
    <section class="relative bg-dark-green text-white" id="features">
        <div class="space-50 hidden-xs"></div>
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-4 hidden-xs hidden-tablet-portrait">
                    <div class="space-60"></div>
                    <div class="text-left">
                        <img src="{{ asset('images/unlocked-iphone.png') }}" alt="">
                    </div>
                </div>
                <div class="col-xs-12 col-sm-6 col-md-8 text-content full-tablet-portrait">
                    <div class="space-20 hidden-md  hidden-tablet-portrait"></div>
                    <h4 class="page-title">RÉALISEZ VOUS-MÊME LE DÉBLOCAGE DE VOTRE PORTABLE DE CHEZ UNIVERSAL MOBILE ET OBTENEZ CES AVANTAGES :</h4>
                    <div class="space-5"></div>
                    {{-- <p>Désimlocker votre portable Orange revient à débloquer votre téléphone pour pouvoir l’utiliser avec tous les opérateurs, en France ou à l’international.</p> --}}
                    <ul class="list-unstyled feature">
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Utilisez des cartes SIM françaises ou étrangères après le déblocage de votre téléphone de chez Universal Mobile.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Une manière simple et rapide pour faire le déblocage de votre portable de chez Universal Mobile.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Effectuez vous-même le déblocage de votre téléphone bloqué par Virgin Mobile depuis votre domicile ou au bureau grâce à notre code en ligne.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Payez trois fois moins cher que chez Virgin Mobile et économisez de l’argent pour le déblocage de votre appareil.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Débloquez votre portable définitivement et si vous n’êtes pas satisfait, nous vous remboursons intégralement.</p>
                            </div>
                        </li>
                        <li class="media">
                            <div class="media-left">
                                <i class="icofont icofont-check-circled"></i>
                            </div>
                            <div class="media-right media-middle">
                                <p>Notre méthode facile et efficace pour effectuer le déblocage de votre téléphone ne représente aucun risque pour la garantie de votre appareil.</p>
                            </div>
                        </li>
                    </ul>
                    <div class="space-20"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- Feature-area / -->

    <!--Client-Area-->
    <section class="relative bg-dirty-white" id="testimonials">
        <div class="space-70"></div>
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="page-title text-green text-bold">QUEL NOS CLIENTS DITES</h3>
                </div>
                <div class="space-20"></div>
            </div>
            <div class="row">
                <div class="col-xs-12 col-md-8 col-md-offset-2 text-center">
                    <div class="client-details-content">
                        <div class="client_details">
                        	@foreach($testimonials as $key => $testimonial)
							<div class="item">
                                <q>
                                    <span class="opening-quote">«</span>
                                    <span class="testimonial">« {{ $testimonial->content }} »</span>
                                </q>
                                <p class="ratings-wrapper">
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star" aria-hidden="true"></i>
                                </p>
                                <h5 class="text-green text-normal">{{ $testimonial->author }}, {{ $testimonial->date }}</h5>
                                <p class="text-sm">{{ $testimonial->place }}</p>
                            </div>
                        	@endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="space-100"></div>
    </section>
    <!--Client-Area / -->
@endsection