@extends('landingpages.templates.root')

@section('head')
<title>{{ $cta }} | Debloquer Telephone</title>
@endsection

@section('form')
<h1 class="form-title">Débloquer votre téléphone mobile en <span class="text-green">3 minutes</span> depuis chez vous!</h1>
<p class="form-subtitle hidden-xs">Bénéficiez d’un code de déblocage 100 % garanti et d’un remboursement intégral si vous n’êtes pas satisfait.</p>
@include('landingpages.partials.form')
@endsection

@section('testimonials')
  	<!--Client-Area-->
    <section class="relative bg-dirty-white" id="testimonials">
        <div class="space-70"></div>
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="page-title text-green text-bold">QUEL NOS CLIENTS DITES</h3>
                </div>
                <div class="space-20"></div>
            </div>
            <div class="row">
                <div class="col-xs-12 col-md-8 col-md-offset-2 text-center">
                    <div class="client-details-content">
                        <div class="client_details">
                        	@foreach($testimonials as $key => $testimonial)
							<div class="item">
                                <q>
                                    <span class="opening-quote">«</span>
                                    <span class="testimonial">« {{ $testimonial->content }} »</span>
                                </q>
                                <p class="ratings-wrapper">
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star filled" aria-hidden="true"></i>
                                    <i class="icofont icofont-star" aria-hidden="true"></i>
                                </p>
                                <h5 class="text-green text-normal">{{ $testimonial->author }}, {{ $testimonial->date }}</h5>
                                <p class="text-sm">{{ $testimonial->place }}</p>
                            </div>
                        	@endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="space-100"></div>
    </section>
    <!--Client-Area / -->
@endsection