@extends('layouts.public')

@section('metatags')
	@if(strlen($brand) > 0)
	<title>{{ ucwords(str_replace('-', ' ', $brand)) }} | Debloquer Telephone</title>
	@else
	<title>Manipulation | Debloquer Telephone</title>
	@endif
	<meta name="description" content="Débloquer votre téléphone portable, déblocage réseau par code opérateur ou constructeur" >
	<meta name="keywords" content="debloquer, debloquer telephone, debloquer portable" >
@endsection

@section('content')
	@include('partials.topmenu')
	<section id="manipulations">

		<div class="container">

			<div class="row">

				<div class="col-sm-12 col-md-12 center-block">

					<h1 id="subpage-title" class="text-center">Manipulations</h1>

                    <div class="space-10"></div>

					<p class="text-center">Choisissez la marque de votre portable pour consulter la manipulation adequate.</p>

					<div class="space-25"></div>



					<div class="row" id="brands">



						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/acer') }}"><i class="icofont icofont-plus-circle"></i> Acer</a>

								</li>

								<li>

									<a href="{{ url('manipulation/alcatel') }}"><i class="icofont icofont-plus-circle"></i> Alcatel</a>

								</li>

								<li>

									<a href="{{ url('manipulation/apple') }}"><i class="icofont icofont-plus-circle"></i> Apple</a>

								</li>

								<li>

									<a href="{{ url('manipulation/archos') }}"><i class="icofont icofont-plus-circle"></i> Archos</a>

								</li>

								<li>

									<a href="{{ url('manipulation/asus') }}"><i class="icofont icofont-plus-circle"></i> Asus</a>

								</li>

								<li>

									<a href="{{ url('manipulation/benq') }}"><i class="icofont icofont-plus-circle"></i> BenQ</a>

								</li>

							</ul>

						</div>

						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/benq-siemens') }}"><i class="icofont icofont-plus-circle"></i> BenQ Siemens</a>

								</li>

								<li>

									<a href="{{ url('manipulation/blackberry') }}"><i class="icofont icofont-plus-circle"></i> Blackberry</a>

								</li>

								<li>

									<a href="{{ url('manipulation/bouygues') }}"><i class="icofont icofont-plus-circle"></i> Bouygues</a>

								</li>

								<li>

									<a href="{{ url('manipulation/caterpillar') }}"><i class="icofont icofont-plus-circle"></i> Caterpillar</a>

								</li>

								<li>

									<a href="{{ url('manipulation/coolpad') }}"><i class="icofont icofont-plus-circle"></i> Coolpad</a>

								</li>

								<li>

									<a href="{{ url('manipulation/doro') }}"><i class="icofont icofont-plus-circle"></i> Doro</a>

								</li>

							</ul>

						</div>

						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/elephone') }}"><i class="icofont icofont-plus-circle"></i> Elephone</a>

								</li>

								<li>

									<a href="{{ url('manipulation/ericsson') }}"><i class="icofont icofont-plus-circle"></i> Ericsson</a>

								</li>

								<li>

									<a href="{{ url('manipulation/global-high-tech') }}"><i class="icofont icofont-plus-circle"></i> Global High Tech</a>

								</li>

								<li>

									<a href="{{ url('manipulation/google-nexus') }}"><i class="icofont icofont-plus-circle"></i> Google Nexus</a>

								</li>

								<li>

									<a href="{{ url('manipulation/honor') }}"><i class="icofont icofont-plus-circle"></i> Honor</a>

								</li>

								<li>

									<a href="{{ url('manipulation/hp') }}"><i class="icofont icofont-plus-circle"></i> HP</a>

								</li>

							</ul>

						</div>



						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/htc') }}"><i class="icofont icofont-plus-circle"></i> HTC</a>

								</li>

								<li>

									<a href="{{ url('manipulation/huawei') }}"><i class="icofont icofont-plus-circle"></i> Huawei</a>

								</li>

								<li>

									<a href="{{ url('manipulation/ice-phone') }}"><i class="icofont icofont-plus-circle"></i> ICE Phone</a>

								</li>

								<li>

									<a href="{{ url('manipulation/intel') }}"><i class="icofont icofont-plus-circle"></i> Intel</a>

								</li>

								<li>

									<a href="{{ url('manipulation/lenovo') }}"><i class="icofont icofont-plus-circle"></i> Lenovo</a>

								</li>

								<li>

									<a href="{{ url('manipulation/lg') }}"><i class="icofont icofont-plus-circle"></i> LG</a>

								</li>

							</ul>

						</div>



						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/meizu') }}"><i class="icofont icofont-plus-circle"></i> Meizu</a>

								</li>

								<li>

									<a href="{{ url('manipulation/microsoft') }}"><i class="icofont icofont-plus-circle"></i> Microsoft</a>

								</li>

								<li>

									<a href="{{ url('manipulation/mitsubishi') }}"><i class="icofont icofont-plus-circle"></i> Mitsubishi</a>

								</li>

								<li>

									<a href="{{ url('manipulation/modelabs') }}"><i class="icofont icofont-plus-circle"></i> Modelabs</a>

								</li>

								<li>

									<a href="{{ url('manipulation/motorola') }}"><i class="icofont icofont-plus-circle"></i> Motorola</a>

								</li>

								<li>

									<a href="{{ url('manipulation/nec') }}"><i class="icofont icofont-plus-circle"></i> NEC</a>

								</li>

							</ul>

						</div>





						<div class="col-md-2 col-xs-6 col">

							<ul class="list-unstyled">

								<li>

									<a href="{{ url('manipulation/nokia') }}"><i class="icofont icofont-plus-circle"></i> Nokia</a>

								</li>

								<li>

									<a href="{{ url('manipulation/oneplus') }}"><i class="icofont icofont-plus-circle"></i> OnePlus</a>

								</li>

								<li>

									<a href="{{ url('manipulation/orange') }}"><i class="icofont icofont-plus-circle"></i> Orange</a>

								</li>

								<li>

									<a href="{{ url('manipulation/palm') }}"><i class="icofont icofont-plus-circle"></i> Palm</a>

								</li>

								<li>

									<a href="{{ url('manipulation/panasonic') }}"><i class="icofont icofont-plus-circle"></i> Panasonic</a>

								</li>

								<li>

									<a href="{{ url('manipulation/qtek') }}"><i class="icofont icofont-plus-circle"></i> Qtek</a>

								</li>

							</ul>

						</div>



					</div>

					

				</div>

			</div>

		</div>

	</section>
	@if(strlen($brand) > 0)
    <section id="unlocking-details">
        <div class="space-50"></div>
		@include('manipulation.'.$brand)
    </section>
    @endif

	<div class="space-85"></div>

	
    @include('partials.footer-cta')
    @include('partials.footer')
@endsection