@extends('layouts.dashboard')

@section('head')
<title>Orders | Debloquer Telephone</title>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">

        	<!-- start: page title -->
            <div id="page-title-wrapper">
                <div class="row">
                	<div class="col-md-3">
                		<h3>
		                    Orders ({{ number_format($orders->total()) }})
		                </h3>
                	</div>
                	<div class="col-md-9 text-right">
                		<div class="filter-wrapper">
                            <form action="" class="form-inline">
                            	<div class="form-group">
                                    <div class='input-group date' id='datetimepicker6'>
                                    	@if(isset($params['start_date']))
                                        <input name="start_date" type='text' value="{{ date('m/d/Y', strtotime($params['start_date'])) }}" class="form-control" />
                                        @else
										<input name="start_date" type='text' value="{{ date('m/d/Y') }}" class="form-control" />
                                        @endif
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class='input-group date' id='datetimepicker7'>
                                    	@if(isset($params['end_date']))
                                        <input name="end_date" type='text' value="{{ date('m/d/Y', strtotime($params['end_date'])) }}" class="form-control" />
                                        @else
										<input name="end_date" type='text' value="{{ date('m/d/Y') }}" class="form-control" />
                                        @endif
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </div>
                                <button class="btn btn-default"><i class="fa fa-filter"></i> Filter</button>
                            </form>
                        </div>
                	</div>
                </div>
                <hr />
            </div>
            <!-- end: page title -->

            <div class="clearfix"></div>

        	@if (session('status'))
                <div class="alert alert-success">
                    {!! session('status') !!}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="section" id="orders-list">
            	@if($orders->total() > 0)
				<p class="text-small text-muted">Showing {{ $orders->firstItem() }} to {{ $orders->lastItem() }} out of {{ $orders->total() }} orders.</p>
				@endif

				<table class="table dash-table">
					<thead>
						<tr>
							<th width="2%">#</th>
							<th>Email</th>
							<th>Name</th>
							<th>Phone</th>
							<th>Model</th>
							<th>Operator</th>
							<th>IMEI</th>
							<th  class="text-center">Price (EUR)</th>
							<th>Date Purchased</th>
							<th>Status</th>
						</tr>
					</thead>
					<tbody>
						@foreach($orders as $orderKey => $order)
						<tr>
							<td data-title="Transaction ID">{{ $orderKey + $orders->firstItem() }}</td>
							<td data-title="Email">{{ $order->email }}</td>
							<td data-title="Name">{{ ucfirst($order->firstname) }} {{ ucfirst($order->lastname) }}</td>
							<td data-title="Phone">{{ $order->phone }}</td>
							<td data-title="Model">{{ $order->model }}</td>
							<td data-title="Model">{{ $order->operator }}</td>
							<td data-title="IMEI">{{ $order->imei }}</td>
							<td class="text-center" data-title="Price">{{ $order->amount }}</td>
							<td data-title="Date Purchased">{{ date('F d, Y h:i A', $order->dateadded) }}</td>
							<td data-title="Status">
								@if($order->status == 'paid')
								<div class="label label-success">Paid</div>
								@elseif($order->status == 'code-sent')
								<div class="label label-info">Code Sent</div>
								@elseif($order->status == 'refunded')
								<div class="label label-danger">Refunded</div>
								@else
								{{ $order->status }}
								@endif

							</td>
						</tr>
						@endforeach

						@if($orders->total() == 0)
						<tr>
							<td colspan="9"><p class="text-muted">No orders found</p></td>
						</tr>
						@endif
					</tbody>
				</table>

	        </div>
			
			@if($orders->total() > 0)
	       	<div class="row">
		      <div class="col-md-2">
		            <form class="form-inline">
		              <div class="form-group">
		                <label for="exampleInputName2">Items per page</label>
		                <select name="per_page" class="form-control" id="per_page_dropdown">
		                    @for($x = 15; $x <= 40; $x+=5)
		                        <option @if(app('request')->input('per_page') == $x) {{ 'selected' }}  @endif value="{{ $x }}">{{ $x }}</option>
		                    @endfor
		                </select>
		              </div>
		            </form>
		        </div>
				<div class="col-md-10 text-right">	
					<nav aria-label="Page navigation">
		    			{{ $orders->appends(app('request')->except('page'))->links() }}
					</nav>
				</div>
			</div>
			@endif

        </div>
    </div>
</div>
@endsection
