@extends('layouts.public')

@section('metatags')
<title>Suivi de Commande | Debloquer Telephone</title>
@endsection

@section('content')
	@include('partials.topmenu-without-links')

    @if(!is_object($order))

    <!-- Track Order / -->
    <section class="relative bg-green text-white" id="track-order">
        <div class="space-60"></div>
        <div class="container">
        	<div class="row">
        		<div class="col-md-12">
        			
    				@if (session('status'))
				        <div class="alert alert-success">
				            {!! session('status') !!}
				        </div>
				    @endif

				    @if (session('error'))
				        <div class="alert alert-danger">
				            {{ session('error') }}
				        </div>
				    @endif
					

		            <form action="{{ url('track-order') }}" method="post">
					    <div class="row">
			                <div class="col-xs-12 col-sm-6 col-md-6">
			                    <div class="text-left text-content">
			                        <h5 class="page-title section-title text-normal">Suivi de commande</h5>
			                        <div class="space-5"></div>
			                        <p class="page-subtitle section-subtitle">Afin de vous identifier, veuillez saisir le numéro Imei de votre téléphone portable.</p>
			                    </div>
			                </div>
			                <div class="col-xs-12 col-sm-6 col-md-6">
			                    <div class="space-20"></div>
			                    	{{ csrf_field() }}
			                        <div class="form-group">
			                            <div class="input-group">
			                                <input type="number" name="imei" class="form-control input-lg" placeholder="Rentrer votre numéro IMEI" required>
			                                <span class="input-group-addon with-input-lg"><i data-toggle="tooltip" data-placement="left" title="Notez uniquement les 15 premiers chiffres, sans tiret ni espace" class="icofont icofont-info-circle"></i></span>
			                            </div>
			                        </div>
			                    </form>
			                </div>
			            </div>
			        </form>

			        <hr />

				    <p>Si nous ne trouvons pas votre commande veuillez vérifier les informations suivantes : </p>

					<p>- Avez-vous bien pris note de votre numéro Imei lors de votre commande ?</p> 
					<p>- Avez-vous rentré uniquement 15 chiffres sans espace, ni tiret, ni virgule ? </p>
					<p>- Etes-vous certain qu`il s`agit bien du bon site marchand ? </p>

					<p>Si malgré cela vous continuez à obtenir un message d`erreur, veuillez prendre contact avec nous en cliquant ici </p>

					<p>* Composez *#06# sur le clavier de votre portable afin d`obtenir votre numero Imei. </p>
        		</div>
        	</div>
            
        </div>
        <div class="space-60"></div>
    </section>
    <!-- Track Order / -->

    @else
    
    	<section id="atf">
    		<div class="container">
    			<div class="row">
    				<div class="col-sm-12 col-md-9 center-block">
    					<h1 id="subpage-title" class="text-center no-margin-bottom">Suivi de commande</h1>
    					<div class="space-50"></div>
    					@if($order->status == 'paid')
						<div class="plain-text-content" id="letter">
    						<p>Cher(e) M. {{ $order->firstname }},</p> 

							<p>Nous avons bien reçu votre demande de code de déblocage.</p> 
						
							<div class="order-details">
								<table>
									<tbody>
										<tr>
											<td>Numéro Imei</td>
											<td>: {{ $order->imei }}</td>
										</tr>
										<tr>
											<td>Marque</td>
											<td>: {{ $order->phone }}</td>
										</tr>
										<tr>
											<td>Modèle</td>
											<td>: {{ $order->model }}</td>
										</tr>
										<tr>
											<td>Opérateur</td>
											<td>: {{ $order->operator }}</td>
										</tr>
									</tbody>
								</table>
							</div>

							<p>Votre demande est déjà en cours de traitement chez l‘opérateur, votre code de déblocage vous sera envoyé sur votre adresse email. Le délai de livraison du code varie entre 1 heure et 72 heures selon l‘opérateur, (délais approximatif sachant que les codes sont traités du lundi au vendredi uniquement, code SFR parfois plus long), nous vous remercions pour votre patience et mettons tout en œuvre afin de vous satisfaire le plus rapidement possible. </p>


							<p>Cordialement. <br />Service Clientèle. </p>

    					</div>
    					@elseif($order->status == 'code-sent')
    					<div class="plain-text-content" id="letter">
    						<p>Cher(e) M. {{ $order->firstname }},</p> 

							<p>Suite à votre demande de code de déblocage, nous vous informons que le code est indisponible.</p> 

							<p>Lorsque le code est indisponible, cela signifie que le constructeur ne l’a pas encore communiqué à l’opérateur. </p>

							<p>Cette réponse de code sera similaire sur tous les sites de déblocage en ligne. </p>

							<div class="order-details">
								<table>
									<tbody>
										<tr>
											<td>Numéro Imei</td>
											<td>: {{ $order->imei }}</td>
										</tr>
										<tr>
											<td>Marque</td>
											<td>: {{ $order->phone }}</td>
										</tr>
										<tr>
											<td>Modèle</td>
											<td>: {{ $order->model }}</td>
										</tr>
										<tr>
											<td>Opérateur</td>
											<td>: {{ $order->operator }}</td>
										</tr>
									</tbody>
								</table>
							</div>

							<p>Si vous désirez patienter, les listes de codes de déblocages sont mise à jour deux fois par mois, il suffit de ne pas demander le remboursement et votre demande restera active. Dans ce cas vous serez averti par email dès que votre code sera disponible. </p>
							
							<p>Si vous préférez un remboursement intégral, il suffit de cliquer sur ce lien et remplir le formulaire de remboursement : http://www.debloquertelephone.fr/remboursement.php </p>

							<p>Nous vous remercions encore pour votre confiance. </p>


							<p>Cordialement. <br />Service Clientèle. </p>

    					</div>
    					@elseif($order->status == 'pending')
    					<div class="plain-text-content" id="letter">
	    					<p>Cher(e) client, </p>

							<p>Il y a quelques minutes, vous venez de visiter notre site debloquertelephone.com afin de débloquer votre {{ $order->phone }} {{ $order->model }} bloqué par {{ $order->operator }} mais malheureusement votre tentative de paiement n‘a pas abouti. ( Si entre-temps vous avez bien effectué votre paiement, veuillez ignorer ce message)</p> 

							<p>Nous vous rappelons qu‘il n‘est pas nécessaire d‘ouvrir un compte Paypal pour régler par carte de crédit, il suffit de cliquer en bas à droite de la page Paypal (bouton ‘Vous n'avez pas de compte PayPal ?‘) et de remplir le formulaire. Paypal procure un environnement de paiement hautement sécurisé mais ne vous oblige jamais à vous inscrire.</p> 


							<p>Nous avons le code de déblocage pour votre {{ $order->phone }} {{ $order->model }} ({{ $order->operator }}). </p>

							<p>Veuillez cliquer <a href="{{ url('/?order_id=$order->order_id') }}">ici</a> pour retourner sur notre site, votre bon de commande est déjà rempli avec vos informations il suffira de les valider. Ensuite votre code sera envoyé très rapidement vers votre boite email et pourrez enfin utiliser votre téléphone portable avec toutes les cartes Sim françaises et étrangères.</p> 

							<p>Chaque client profite de notre garantie satisfait ou remboursé.</p> 

							<p>Pour la moindre question, veuillez utiliser le formulaire de contact et nous serons heureux de vous répondre rapidement. </p>


							<p>Cordialement. <br />Service Clientèle. </p>
						</div>
    					@endif
    				</div>
    			</div>
    		</div>
    		<div class="space-50"></div>
    	</section>

    	@include('partials.brands')
	  	@include('partials.footer-cta')

	 @endif

    @include('partials.footer')
@endsection