<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'SiteController@home');
// Route::get('terms', 'SiteController@terms');
Route::get('tos', 'SiteController@terms');
Route::get('merci', 'SiteController@thankYou');
Route::get('manipulation/{brand?}', 'SiteController@manipulation');
Route::get('faq', 'SiteController@faq');

Route::post('add-to-cart', 'OrderController@addToCart');
Route::post('models', 'SiteController@getModelsByManufacturer');

Auth::routes();

Route::get('confirm', 'SiteController@confirm')->name('confirm');
Route::post('checkout', 'CheckoutController@checkout')->name('checkout');
Route::get('payment-successful', 'CheckoutController@paymentSuccessful')->name('payment-successful');
Route::get('payment-cancelled', 'CheckoutController@paymentCancelled')->name('payment-cancelled');
Route::get('suivi', 'SiteController@track')->name('track');
Route::get('contact', 'SiteController@contact')->name('contact');
Route::post('track-order', 'SiteController@trackOrder')->name('trackOrder');

// landing pages
Route::get('desimlocker', 'LandingPageController@desimlocker')->name('desimlocker');
Route::get('debloquer', 'LandingPageController@debloquer')->name('debloquer');
Route::get('desimlockage', 'LandingPageController@desimlockage')->name('desimlockage');
Route::get('deblocage', 'LandingPageController@deblocage')->name('deblocage');

Route::get('desimlocker/{name}', 'LandingPageController@desimlockerName')->name('desimlocker-name');
Route::get('debloquer/{name}', 'LandingPageController@debloquerName')->name('debloquer-name');
Route::get('desimlockage/{name}', 'LandingPageController@desimlockageName')->name('desimlockage-name');
Route::get('deblocage/{name}', 'LandingPageController@deblocageName')->name('deblocage-name');

Route::group(['middleware' => ['auth'], 'prefix' => 'dashboard'], function() {
	Route::get('orders', 'DashboardController@orders');
});

Route::get('email', 'CheckoutController@testEmail');

Route::get('track-paid-order', 'SiteController@trackPaidOrder');
Route::get('track-pending-order', 'SiteController@trackPendingOrder');
Route::get('track-code-sent-order', 'SiteController@trackCodeSentOrder');
