<!DOCTYPE html>
<html lang="<?php echo e(config('app.locale')); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <?php echo $__env->yieldContent('head'); ?>

    <!-- Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/vendor/normalize.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/vendor/bootstrap-datetimepicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/vendor/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/media-query.css')); ?>">

    <!-- Scripts -->
    <script>
        window.Laravel = <?php echo json_encode([
            'csrfToken' => csrf_token(),
        ]); ?>;

        window.Laravel.BASE_URL = <?php echo json_encode(url('/')); ?>;
    </script>
</head>
<body id="body-container">
	<div id="preloader">
      <div id="preloader-inner">
        <span class="pulse"></span>
        <span id="preloader-text">Please wait...</span>
      </div>
    </div>

	<header id="header">
		<?php echo $__env->make('templates.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	</header>

	<div id="main-content">
		<?php echo $__env->yieldContent('content'); ?>
	</div>

	<footer class="footer" id="footer">
      <div class="container">
        <p class="text-muted">Powered by Debloquer Telephone. © <?php echo e(date('Y')); ?> Copyright. All Rights Reserved</p>
      </div>
    </footer>

    <!-- JavaScripts -->
    <script src="<?php echo e(asset('dashboard/js/vendor/jquery-1.12.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/vendor/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/vendor/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/vendor/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/vendor/Chart.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dashboard/js/vendor/toastr.min.js')); ?>"></script>

    <script src="<?php echo e(asset('dashboard/js/main.js')); ?>"></script>

    <?php echo $__env->yieldContent('custom_js'); ?>

   	<script type="text/javascript">
   		$(window).load(function() {
		    $('#preloader').css('display', 'none');
		});

        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
            $('#datetimepicker6').datetimepicker({
                format: 'MM/DD/YYYY'
            });
            $('#datetimepicker7').datetimepicker({
                useCurrent: false,
                format: 'MM/DD/YYYY'
            });
            $('#datetimepicker8').datetimepicker({
                useCurrent: false,
                format: 'MM/DD/YYYY'
            });
            $('#datetimepicker9').datetimepicker({
                useCurrent: false,
                format: 'MM/DD/YYYY'
            });
            $("#datetimepicker6").on("dp.change", function (e) {
                $('#datetimepicker7').data("DateTimePicker").minDate(e.date);
            });
            $("#datetimepicker7").on("dp.change", function (e) {
                $('#datetimepicker6').data("DateTimePicker").maxDate(e.date);
                $('#datetimepicker8').data("DateTimePicker").minDate(e.date);
            });
            $("#datetimepicker8").on("dp.change", function (e) {
                $('#datetimepicker7').data("DateTimePicker").maxDate(e.date);
                $('#datetimepicker9').data("DateTimePicker").minDate(e.date);
            });
            $("#datetimepicker9").on("dp.change", function (e) {
                $('#datetimepicker8').data("DateTimePicker").maxDate(e.date);
            });

            if(location.search.split('?').length > 1) {
                var q = {};
                location.search.split('?')[1].split('&').forEach(function(i){
                    q[i.split('=')[0]]=i.split('=')[1];
                });
            }

            $('#per_page_dropdown').bind('change', function () {
                var path = '/';
                var pathname = window.location.pathname.split( '/' );

                var final_pathname = '';

                for (var i = 1; i < pathname.length; i++) {
                    final_pathname += pathname[i];
                    if( i != pathname.length - 1) {
                        final_pathname += '/';
                    }
                }

                var url = window.Laravel.BASE_URL + path + final_pathname + '?';

                $.each(q, function(index, value) {
                    if(index != 'per_page') {
                        url += index + '=' + value + '&';
                    }
                }); 

                url += 'per_page=' + $(this).val();
                
                window.location.href = url; 
              
            });

        });
	</script>
</body>
</html>
