<?php $__env->startSection('head'); ?>
<title>Login | DebloquerTelephone Dashboard</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="page-overlay"></div>
<div id="page-overlay-color"></div>
<div id="content-wrapper">
    <div class="container-fluid height-100">
        <div class="row height-100">
            <div class="col-md-12 height-100">
                <div id="login-page">
                    <div class="text-center login-logo-wrapper">
                        <img src="<?php echo e(url('images/logo.png')); ?>" alt="DebloquerTelephone Logo">
                    </div>
                    <?php if(session('status')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>
                    <form class="" role="form" method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo e(csrf_field()); ?>


                        <div class="form-group<?php echo e($errors->has('username') ? ' has-error' : ''); ?>">
                            <label for="username" class="control-label">Username</label>
                            <input id="username" type="text" class="form-control" name="username" value="<?php echo e(old('username')); ?>">
                            <?php if($errors->has('username')): ?>
                                <span class="help-block">
                                    <strong><?php echo e($errors->first('username')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                            <label for="password" class="control-label">Password</label>
                            <input id="password" type="password" class="form-control" name="password">
                            <?php if($errors->has('password')): ?>
                                <span class="help-block">
                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>> Remember Me
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-green">
                                <i class="fa fa-btn fa-sign-in"></i> Login
                            </button>

                            <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>">Forgot Your Password?</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>