<?php $__env->startSection('head'); ?>
<title>Orders | Debloquer</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">

        	<!-- start: page title -->
            <div id="page-title-wrapper">
                <div class="row">
                	<div class="col-md-3">
                		<h3>
		                    Orders (<?php echo e(number_format($orders->total())); ?>)
		                </h3>
                	</div>
                	<div class="col-md-9 text-right">
                		<div class="filter-wrapper">
                            <form action="" class="form-inline">
                            	<div class="form-group">
                                    <div class='input-group date' id='datetimepicker6'>
                                    	<?php if(isset($params['start_date'])): ?>
                                        <input name="start_date" type='text' value="<?php echo e(date('m/d/Y', strtotime($params['start_date']))); ?>" class="form-control" />
                                        <?php else: ?>
										<input name="start_date" type='text' value="<?php echo e(date('m/d/Y')); ?>" class="form-control" />
                                        <?php endif; ?>
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class='input-group date' id='datetimepicker7'>
                                    	<?php if(isset($params['end_date'])): ?>
                                        <input name="end_date" type='text' value="<?php echo e(date('m/d/Y', strtotime($params['end_date']))); ?>" class="form-control" />
                                        <?php else: ?>
										<input name="end_date" type='text' value="<?php echo e(date('m/d/Y')); ?>" class="form-control" />
                                        <?php endif; ?>
                                        <span class="input-group-addon">
                                            <span class="glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </div>
                                <button class="btn btn-default"><i class="fa fa-filter"></i> Filter</button>
                            </form>
                        </div>
                	</div>
                </div>
                <hr />
            </div>
            <!-- end: page title -->

            <div class="clearfix"></div>

        	<?php if(session('status')): ?>
                <div class="alert alert-success">
                    <?php echo session('status'); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="section" id="orders-list">
            	<?php if($orders->total() > 0): ?>
				<p class="text-small text-muted">Showing <?php echo e($orders->firstItem()); ?> to <?php echo e($orders->lastItem()); ?> out of <?php echo e($orders->total()); ?> orders.</p>
				<?php endif; ?>

				<table class="table dash-table">
					<thead>
						<tr>
							<th width="2%">#</th>
							<th>Email</th>
							<th>Name</th>
							<th>Phone</th>
							<th>Model</th>
							<th>Operator</th>
							<th>IMEI</th>
							<th  class="text-center">Price (EUR)</th>
							<th>Date Purchased</th>
							<th>Status</th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderKey => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td data-title="Transaction ID"><?php echo e($orderKey + $orders->firstItem()); ?></td>
							<td data-title="Email"><?php echo e($order->email); ?></td>
							<td data-title="Name"><?php echo e(ucfirst($order->firstname)); ?> <?php echo e(ucfirst($order->lastname)); ?></td>
							<td data-title="Phone"><?php echo e($order->phone); ?></td>
							<td data-title="Model"><?php echo e($order->model); ?></td>
							<td data-title="Model"><?php echo e($order->operator); ?></td>
							<td data-title="IMEI"><?php echo e($order->imei); ?></td>
							<td class="text-center" data-title="Price"><?php echo e($order->amount); ?></td>
							<td data-title="Date Purchased"><?php echo e(date('F d, Y h:i A', $order->dateadded)); ?></td>
							<td data-title="Status">
								<?php if($order->status == 'paid'): ?>
								<div class="label label-success">Paid</div>
								<?php elseif($order->status == 'code-sent'): ?>
								<div class="label label-info">Code Sent</div>
								<?php elseif($order->status == 'refunded'): ?>
								<div class="label label-danger">Refunded</div>
								<?php else: ?>
								<?php echo e($order->status); ?>

								<?php endif; ?>

							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						<?php if($orders->total() == 0): ?>
						<tr>
							<td colspan="9"><p class="text-muted">No orders found</p></td>
						</tr>
						<?php endif; ?>
					</tbody>
				</table>

	        </div>
			
			<?php if($orders->total() > 0): ?>
	       	<div class="row">
		      <div class="col-md-2">
		            <form class="form-inline">
		              <div class="form-group">
		                <label for="exampleInputName2">Items per page</label>
		                <select name="per_page" class="form-control" id="per_page_dropdown">
		                    <?php for($x = 15; $x <= 40; $x+=5): ?>
		                        <option <?php if(app('request')->input('per_page') == $x): ?> <?php echo e('selected'); ?>  <?php endif; ?> value="<?php echo e($x); ?>"><?php echo e($x); ?></option>
		                    <?php endfor; ?>
		                </select>
		              </div>
		            </form>
		        </div>
				<div class="col-md-10 text-right">	
					<nav aria-label="Page navigation">
		    			<?php echo e($orders->appends(app('request')->except('page'))->links()); ?>

					</nav>
				</div>
			</div>
			<?php endif; ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>